﻿// (c) Copyright 2024.  Adobe Systems, Incorporated.  All rights reserved.

// This JavaScript is to be read by Bridge, InCopy, and other Adobe apps at
// launch. It implements the CrossDOM for InCopy

/*
@@@BUILDINFO@@@ incopy-20.0.jsx 20.0.0.0
*/

/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe InCopy 2025 との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe InCopy 2025 kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe InCopy 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe InCopy 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Dit script laat andere toepassingen toe te communiceren met Adobe InCopy 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Este script permite que outros aplicativos se comuniquem com o Adobe InCopy 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Skriptet gjør at andre programmer kan kommunisere med Adobe InCopy 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Dette script betyder, at andre programmer kan kommunikere med Adobe InCopy 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Tämän komentosarjan avulla muut sovellukset ja Adobe InCopy 2025 voivat kommunikoida keskenään</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Det här skriptet gör det möjligt för andra program att kommunicera med Adobe InCopy 2025</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>此指令碼能讓其他應用程式與 Adobe InCopy 2025 進行通訊。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>此脚本使其它应用程序能够与 Adobe InCopy 2025 进行通信</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe InCopy 2025과(와) 통신할 수 있습니다.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="cs_CZ">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Tento skript umožňuje ostatním aplikacím komunikovat s aplikací Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pl_PL">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Ten skrypt umożliwia innym aplikacjom komunikowanie się z programem Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="hu_HU">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Ez a szkript lehetővé teszi más alkalmazások számára, hogy kommunikáljanak az Adobe InCopy 2025 programmal. </dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ru_RU">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Этот сценарий позволяет другим приложениям осуществлять связь с Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="tr_TR">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Bu komut dosyası diğer uygulamaların Adobe InCopy 2025 ile iletişim kurmasını sağlar.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="uk_UA">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Цей сценарій активує зв'язок інших програм з Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ar_AE">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>يتيح هذا النص التنفيذي للتطبيقات الأخرى أن تتصل بـ Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="he_IL">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>סקריפט זה מאפשר ליישומים אחרים לתקשר עם Adobe InCopy 2025.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="el_GR">
     <dc:title>Adobe InCopy 2025</dc:title>
     <dc:description>Αυτή η δέσμη ενεργειών δίνει τη δυνατότητα σε άλλες εφαρμογές να επικοινωνούν με το Adobe InCopy 2025.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/


// debug level: 0-2 (0:disable, 1:break on error, 2:break at beginning)
// $.level = 1;
// debugger; // launch debugger on next line
//=================================================================

//alert("\"" + BridgeTalk.appName + "\" is loading: incopy-20.0.jsx");

var incopyApp = {};

incopyApp.createInCTestMenuInBridgeApp = false;	// Set to true to see InC CrossDOM test menu

// Some global strings (scoped to avoid collisions)
incopyApp.bridgeTargetName = 					"bridge";
incopyApp.inDesignTargetName = 				"indesign";
incopyApp.inCopyTargetName =					"incopy";
incopyApp.inCopyVersionedTargetName =		"incopy-20";
incopyApp.inDesignServerTargetName =			"indesignserver";

incopyApp.bridgeAppName = 					"bridge";
incopyApp.inDesignAppName = 					"indesign";
incopyApp.inCopyAppName = 					"incopy";
incopyApp.inDesignServerAppName =				"indesignserver";

incopyApp.versionID = 						20.0;
incopyApp.targetName = 						"incopy";

incopyApp.strings4PlaceMenu=[
		/*00*/ "$$$/extendscript/incopy/Menu/Place/InInCopy=In InCopy",
		/*01*/ "$$$/extendscript/incopy/Error/NoOpenDocForPlaceError=Scripted place (incopy.place) requires an active document window."
];

//=================================================================
// CrossDOM/X-DOM
// Implements InCopy's cross DOM API - the a small set of
// operations that are common to all Adobe apps.
//=================================================================

//=======================================================
//	quit() 
//	- Performs the equivalent of File->Exit or File->Close.
//
//	return value
//		undefined
//=======================================================
incopyApp.quit = function ( )
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		incopyApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.quit();
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke Quit
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.quit();";
		var result = btMessage.send();
	}
}

//=======================================================
//	activate
//	- Activate InCopy (not part of cross DOM)
//=======================================================
incopyApp.activate = function ( )
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		incopyApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke Activate
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.activate();";
		var result = btMessage.send();
	}
}

//=======================================================
//	open( files ) 
//	- Performs the equivalent of File->Open on the requested files. 
//	Accepts either an Array object or a single path.
//	
//	return value						undefined
//
//	files										File or Array of File	files to display in new Window
//=======================================================
incopyApp.open = function ( /*list of*/ files )
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		
		incopyApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();	// Activate to be sure any dialogs or alerts resulting from the open can be seen by the user.

		var fileArray = incopyApp.extractFileArray ( files ); 

		for ( index = 0; index < fileArray.length; ++index )
		{
			var file = fileArray[index];
			
			app.open( file ); //open the files one at a time to get individual return codes.
		}
	}
	else
	{	
		
		var fileArray = incopyApp.extractFileArray ( files );

		// Create a new BridgeTalk message for InCopy to invoke Open
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.open (" + fileArray.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	openAsNew([creation-options]) 
//	- Performs the equivalent of File->New. 
//		If a folder is provided, a new, untitled document should be opened with that folder as its location. 
//		If a path to a file is given, a new document should be opened with the specified name and location. 
//		The creation-options are app-specific.
//
//	return value: 
//		Boolean		True if successful
//=======================================================
incopyApp.openAsNew = function () 
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		incopyApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		var showingWindow = true;
		var documentPreset = null;
		
		// Check for valid creation options
		if (arguments.length > 0)
		{
			// [showingWindow]: boolean
			for (var i = 0; i < arguments.length; i++)
			{
				if (typeof(arguments[i]) == "boolean")
				{
					showingWindow = arguments[i];
					break;
				}
			}
			
			// [documentPreset]: object or string(name of preset)
			for (var i = 0; i < arguments.length; i++)
			{
				if (typeof(arguments[i]) == "string")
				{
					documentPreset = arguments[i];
					break;
				}
				if (typeof(arguments[i]) == "object" && arguments[i] instanceof documentPreset)
				{
					documentPreset = arguments[i];
					break;
				}
			}
		}

		// create the new document
		var newDocument = app.documents.add(showingWindow, documentPreset);
		if (newDocument != null)
			return true;
		else
			return false;
		
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke openAsNew
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.openAsNew (";
		if (arguments.length > 0)
		{
			for (var i = 0; i < arguments.length; i++)
			{
				btMessage.body += arguments[i].toSource();
			}
		}
		btMessage.body += ");";
		
		btMessage.send();
	}
}

//=======================================================
//	print( files ) 
//	- Performs the equivalent of File->Print on the requested files.
//	
//	return value
//		undefined (app.print has no return value)
//	
//	files
//		File or Array of File			files to be printed
//=======================================================
incopyApp.print = function ( /*list of*/ files )
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		incopyApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM
		
		var fileArray = incopyApp.extractFileArray ( files ); 
		for ( index = 0; index < fileArray.length; ++index )
		{
			var file = fileArray[index];
			
			app.print( file, /*[printDialog]*/ false /*, [using] printerPreset */ ); //print the files one at a time?
		}
	}
	else
	{
		var fileArray = incopyApp.extractFileArray ( files );

		// Create a new BridgeTalk message for InCopy to invoke Print
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.print (" + fileArray.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	reveal( file ) 
//	- Gives the target app focus and brings the specified document to the foreground if it is already open.
//	
//	return value
//		Boolean		true if the file was open and was successfully brought to the foreground
//=======================================================
incopyApp.reveal = function ( file ) 
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		incopyApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();

		// Convert the argument into a File.
		if( typeof file == "string" )
			file = incopyApp.convertPathStrToFile( file );
		
		if(app.documents.length != 0)
		{
			//alert("incopyApp.reveal: document count is:" + app.documents.length.toString());

			// Search the open documents to see if any of them are the one in question
			for(myCounter = 0; myCounter < app.documents.length; myCounter++)
			{
				aDocument = app.documents.item(myCounter);
				
				if (aDocument.saved)
				{
					//alert("incopyApp.reveal: Document name is :" + aDocument.fullName.toString());
					if (aDocument.fullName.toString() == file.toString())
					{
						//alert("incopyApp.reveal: We have a match!");
						// Activate this document
						app.activeDocument = aDocument;
						return true;
					}
				}
			}
		}
		return false;
	}
	else
	{
		if( typeof file == "string" )
			file = incopyApp.convertPathStrToFile( file );

		// Create a new BridgeTalk message for InCopy to invoke reveal
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.reveal (" + file.toSource() + ");";
		btMessage.send();
	}
}

//=======================================================
//	place( files, showImportOptions ) 
//	-	Performs the equivalent of the File->Place command on the requested files. 
//		showImportOptions
//			Boolean		true if the ImportOptions dialog should be shown
//
//	return value
//		Boolean		true if the files were successfully placed
//=======================================================
incopyApp.place = function ( file, showImportOptions ) 
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		
		incopyApp.validateScriptVersion(); //Make sure we're using an appropriate version of the DOM

		app.activate();	// Activate to be sure any dialogs or alerts resulting from the open can be seen by the user.
		
		if (app.documents.length == 0 )
		{
			app.documents.add();
		}
		
		var placeOK = true;
		if(app.activeDocument != undefined)
		{
			//alert("incopyApp.place: has active document!");

			placeOK = app.activeDocument.selection[0].place(file);
			return placeOK;
 		}
		return false;
	}
	else
	{

		// Create a new BridgeTalk message for InCopy to invoke place
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.place (" + file.toSource() + "," + showImportOptions + ");";
		btMessage.send();
		return true;
	}
}

//=======================================================
//	executeScript( script ) 
//	- Performs an "eval" on the given script.
//
//	return value
//		Object		The value of evaling the last line of the script
//	
//	script
//		String		The script to be evaled
//=======================================================
incopyApp.executeScript = function ( script )
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		return eval( script );
	}
	else
	{
		// Create a new BridgeTalk message for InCopy to invoke executeScript
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.executeScript (" + script + ");";
		btMessage.send();
	}
}

//=======================================================
//	executeScriptFile
//=======================================================
incopyApp.executeScriptFile = function ( file )
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		if( typeof file == "string" )
			file = incopyApp.convertPathStrToFile( file );

		var f = File( file );
		f.open( 'r', 'text', '' );
		var script = f.read();
		retval = eval( script );
		f.close();
		return retval;
	}
	else
	{
		if( typeof file == "string" )
			file = incopyApp.convertPathStrToFile( file );

		// Create a new BridgeTalk message for InCopy to invoke executeScriptFile
		var btMessage = new BridgeTalk;
		btMessage.target = incopyApp.inCopyVersionedTargetName;
		btMessage.body = "incopyApp.executeScriptFile (" + file.toSource() + ");";
		btMessage.send();
	}
}

//========================================================================================================
// This routine Makes sure the ID/IC scriptDOM we're working with is set to at least the minimal level required.
incopyApp.validateScriptVersion = function ()
{
	if( BridgeTalk.appName == incopyApp.inCopyTargetName )
	{
		if (app.scriptPreferences.version < 20.0)
			app.scriptPreferences.version = 20.0 ; //New CC defines the 20.0 version of the DOM
	}
}

// This routine sets the argument menu node to be enabled, if InCopy is running.
incopyApp.enabledIfRunning = function (menuItem)
{
	if( BridgeTalk.isRunning(incopyApp.inCopyVersionedTargetName) )
		menuItem.enabled = true;
	else
		menuItem.enabled = false;
}

// This routine sets the argument menu node to be enabled if one non-container item is selected.
incopyApp.singleFileSelectionEnabled = function (menuItem)
{
	menuItem.enabled = false;

	if (app.document != undefined && app.document.selectionLength == 1)
	{
		if (app.document.selections[0].container == true)	
			menuItem.enabled = false;
		else
			menuItem.enabled = true;
	}
}

incopyApp.selectionEnabledIfIsInCopyDocs = function (menuItem)
{
	incopyApp.selectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	if ( app.document == undefined ) {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that the selected item is an InCopy document
	//	(compare item against valid InCopy document extensions, and type/creator
	menuItem.enabled = true;
	var sel = app.document.selections;
	for (i=0; i < sel.length; i++)
	{
		if (incopy.isInCopyDocument(sel[i]) == false)
		{
			menuItem.enabled = false;
			break;
		}
	}
}

incopyApp.selectionEnabledIfIsScriptFile = function (menuItem)
{
	incopyApp.singleFileSelectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	if ( app.document == undefined ) {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that the selected item is a script file
	var scriptExtensions = ["js", "jsx"];
	menuItem.enabled = incopyApp.matchesFileExtensions(app.document.selections[0], scriptExtensions);	
}

incopyApp.selectionEnabledIfRunningAndIsInCopyDoc = function (menuItem)
{
	if( BridgeTalk.isRunning(incopyApp.inCopyVersionedTargetName) )
		menuItem.enabled = true;
	else
		menuItem.enabled = false;
	
	if (menuItem.enabled == false)
		return;

	incopyApp.singleFileSelectionEnabled(menuItem);
	
	if (menuItem.enabled == false)
		return;
	
	// Validate that the selected item is an InCopy document
	//	(compare item against valid InCopy document extensions, and type/creator

	menuItem.enabled = incopyApp.isInCopyDocument(app.document.selections[0]);
}

incopyApp.matchesFileExtensions = function ( aThumbnail, extensionsToMatch )
{
	// WORKAROUND: We are currently using Thumbnail.name instead of spec.name
	// (BRIDGE BUG: getting spec for managed files forces a replica download)
	var period = ".";
	var index = aThumbnail.name.toString().lastIndexOf(period);
	if (index > -1)
	{
		ext = aThumbnail.name.substring(index+1).toLowerCase();
		if (extensionsToMatch.length > 0)
		{
			for (var extIndex = 0; extIndex < extensionsToMatch.length; extIndex++ )
			{
				if (ext == extensionsToMatch[extIndex])
					return true;
			}
		}
	}
	return false;
}

incopyApp.matchesMacFileType = function ( fileType, fileTypesToMatch )
{	
	if (fileTypesToMatch.length > 0 && fileType != "????" && fileType != "    " && fileType != null)
	{
		for (var i = 0; i < fileTypesToMatch.length; i++ )
		{
			if (fileType == fileTypesToMatch[i])
				return true;
		}
	}
	return false;
}

incopyApp.isInCopyDocument = function ( aThumbnail )
{
	// Check file Extension (.indd)
	var inCopyDocExtensions = ["incx", "inca", "inct"];
	var inCopyDocTypes = ["ICx4", "InCA", "sCx4"]; // FIX - add new types, if any
	if (incopyApp.matchesFileExtensions(aThumbnail, inCopyDocExtensions) == true)
	{
		return true;
	}
	else
	{
		// Else check file type - MacOS only
		// (BRIDGE BUG: getting spec for managed files forces a replica download)
		var aFile = aThumbnail.spec;
		if (incopyApp.matchesMacFileType(aFile.type, inCopyDocTypes))
		{
			return true;
		}
	}
	return false;
}

// This routine sets the argument menu node to be enabled if something is selected.
incopyApp.selectionEnabled = function (menuItem)
{
	menuItem.enabled = false;
	
	if (app.document != undefined && app.document.selectionLength > 0)
	{
		menuItem.enabled = true;
		var sel = app.document.selections;
		for (i=0; i<sel.length; i++)
		{
			if (sel[i].container == true)
			{
				menuItem.enabled = false;
				break;
			}
		}
	}
}

// This routine sets the argument menu node to be enabled if something is selected and app is running.
incopyApp.selectionEnabledIfRunning = function (menuItem)
{
	menuItem.enabled = false;
	
	if( app.document != undefined && app.document.selectionLength > 0 && BridgeTalk.isRunning(incopyApp.inCopyVersionedTargetName) )
	{
		menuItem.enabled = true;
		var sel = app.document.selections;
		for (i=0; i<sel.length; i++)
		{
			if (sel[i].container == true)
			{
				menuItem.enabled = false;
				break;
			}
		}
	}
}

//=========================================================================================================================
//-----------------------------------------------------------------
// This routine tries to return an array of File objects created
// from the 'files' argument. It will convert a single File object
// or a single string into an array of File objects, or it will
// convert an array of string and File objects into an array of
// file objects.
//-----------------------------------------------------------------
incopyApp.extractFileArray = function (files)
{
	var fileArray = new Array;
	
	// If it isn't an array, make it a length one array.
	if (!(files instanceof Array))
		files = new Array (files);
	
	// Turn each item in the array into a File, or remove it.
	for (index = 0; index < files.length; ++index)
	{
		var file = files[index];
		
		if (file instanceof File)
			fileArray.push (file);
		else if (typeof file == 'string')
			fileArray.push (File (file));
		else
		{
			// do nothing
		}
	}
	
	return fileArray;
}

incopyApp.convertPathStrToFile = function( file )
{
	return File( file );
}

incopyApp.thumbNailArrayToFileArray = function (/* Array of thumbNails */ thumbNails)
{
	var files = [];

	for (var index = 0; index < thumbNails.length; index++ )
	{
		files.push(thumbNails[index].spec);
	}
	
	return files;
}

//=======================================================
//	IsAppInstalled( target, versionNumber ) 
//	- Is the specified version of an app installed.
//	
//	return value
//		boolean
//	
//	target
//		string			specifier for the app (i.e. indesign or incopy)
//	versionNumber
//		number			version number (not a string) for the app (i.e. 20.0)
//=======================================================
// 
incopyApp.IsAppInstalled = function(targetName, targetVersionID)
{
	var appNameRoot = targetName+'-';	// 'indesign-' or 'incopy-'

	var thisVersionExists = false;
	
	// Is any version of "targetName" installed 
	if (BridgeTalk.getTargets (0).join ().indexOf (appNameRoot) != -1)
	{
		apps = BridgeTalk.getTargets(0);
		for( var i = 0; i < apps.length; i++ )
		{
			var appspec = apps[i];
			if( appspec.indexOf(appNameRoot) == 0 )
			{
				// Get the versionID for this 
				var versionID = appspec.substring(appspec.indexOf('-')+1)
				
				if ((versionID == targetVersionID) || (versionID.indexOf(targetVersionID) == 0))
				{
					thisVersionExists = true;
				}
			}
		}
	}

	return thisVersionExists;
}


//=====================================================================================================
// I n C o p y    T e s t    M e n u   (installed into the Bridge app to test integration)
//	Do this when the latter apps is starting up (InCopy or Bridge) and the other is running.
//=====================================================================================================

incopyApp.testMenuInstalledInBridge = false;
incopyApp.installTestMenuInBridge = function ()
{
	if (BridgeTalk.appName == incopyApp.bridgeAppName)
	{
		if (incopyApp.testMenuInstalledInBridge == true)
			return;
			
		//alert("Bridge ready to install InCopy Test menu");
		incopyApp.testMenuInstalledInBridge = true;

		// Create a new menu for testing integration with InCopy, add it after the Bridge's Help menu
		incopyApp.testMenu = {};
		incopyApp.testMenu.menu = MenuElement.create("menu", "InC5Test", "after Help", "inCopyTestMenu", incopyApp.inCopyTargetName);
	 
		// The code below inserts various menu items into the InCopyTest menu.
		incopyApp.testMenu.newDocItem = MenuElement.create("command", "New InCopy Pub", "at the end of inCopyTestMenu", "new_in_incopy_test", incopyApp.inCopyTargetName);
		incopyApp.testMenu.newDocItem.onSelect = function () {incopyApp.openAsNew ();};
 
		incopyApp.testMenu.openItem = MenuElement.create("command", "Open in InCopy", "after new_in_incopy_test", "open_in_incopy_test", incopyApp.inCopyTargetName);
		incopyApp.testMenu.openItem.onDisplay = function () {incopyApp.selectionEnabledIfIsInCopyDocs(this);};
		incopyApp.testMenu.openItem.onSelect = function () {incopyApp.open (incopyApp.thumbNailArrayToFileArray(app.document.selections));};
	
		incopyApp.testMenu.revealItem = MenuElement.create("command", "Reveal in InCopy", "after open_in_incopy_test", "reveal_in_incopy_test", incopyApp.inCopyTargetName);
		incopyApp.testMenu.revealItem.onDisplay = function () {incopyApp.selectionEnabledIfRunningAndIsInCopyDoc(this);};
		incopyApp.testMenu.revealItem.onSelect = function () {incopyApp.reveal (incopyApp.thumbNailArrayToFileArray(app.document.selections));};
	
		incopyApp.testMenu.printItem = MenuElement.create("command", "Print in InCopy", "after reveal_in_incopy_test", "print_in_incopy_test", incopyApp.inCopyTargetName);
		incopyApp.testMenu.printItem.onDisplay = function () {incopyApp.selectionEnabledIfIsInCopyDocs(this);};
		incopyApp.testMenu.printItem.onSelect = function () {incopyApp.print (incopyApp.thumbNailArrayToFileArray(app.document.selections));};
	
		incopyApp.testMenu.runScriptItem = MenuElement.create("command", "Run Script in InCopy", "after print_in_incopy_test", "run_incopy_script_test", incopyApp.inCopyTargetName);
		incopyApp.testMenu.runScriptItem.onDisplay = function () {incopyApp.selectionEnabledIfIsScriptFile(this);};
		incopyApp.testMenu.runScriptItem.onSelect = function () {incopyApp.executeScriptFile (incopyApp.thumbNailArrayToFileArray(app.document.selections));};
	
		incopyApp.testMenu.activateItem = MenuElement.create("command", "Activate InCopy", "after run_incopy_script_test", "activate_incopy_test", incopyApp.inCopyTargetName);
		incopyApp.testMenu.activateItem.onDisplay = function () {incopyApp.enabledIfRunning(this);};
		incopyApp.testMenu.activateItem.onSelect = incopyApp.activate;
	
		incopyApp.testMenu.quitItem = MenuElement.create("command", "Quit InCopy", "after activate_incopy_test", "quit_incopy_test", incopyApp.inCopyTargetName);
		incopyApp.testMenu.quitItem.onDisplay = function () {incopyApp.enabledIfRunning(this);};
		incopyApp.testMenu.quitItem.onSelect = incopyApp.quit;
	}
}

// Place the selected document in InCopy.
incopyApp.placeSelectionInInCopy = function (showImportOptions)
{
	var fileArray = incopyApp.thumbNailArrayToFileArray(app.document.selections);
	incopyApp.place (fileArray[0], showImportOptions);
}

incopyApp.selectionEnabledIfIsPlaceable = function (menuItem)
{
	if( app.document != undefined && app.document.selectionLength == 1 && app.document.selectionLength <= 50 ) {
		menuItem.enabled = true;
	}
	else {
		menuItem.enabled = false;
		return;
	}
	
	// Validate that docs are placeable
	menuItem.enabled = true;
	var sel = app.document.selections;
	for (i=0; i < sel.length; i++)
	{
		var aThumbNail = sel[i];
		
		if ( aThumbNail.container == true ) {
			// alert("This is a non-placeable container.");
			menuItem.enabled = false;
			break;
		}
	}
}

//=====================================================================================================
// Install the Place in InDesign menu items
//	Do this when the latter apps is starting up (InDesign or Bridge) and the other is running.
//     *** Bridge guidance says to to this at Bridge Startup time - don't defer til later ***
//=====================================================================================================
// Install the Place in InDesign menu items.
incopyApp.placeMenuItemsInstalledInBridge = false;
incopyApp.installPlaceMenuItems = function ()
{
	if (BridgeTalk.appName == incopyApp.bridgeAppName)
	{
		if (incopyApp.placeMenuItemsInstalledInBridge == true)
			return;
			
		// alert("Ready to install Place in InDesign menu items.");

 		incopyApp.placeMenu = {};
		var menuExists = MenuElement.find("place_in_incopy");
		if (menuExists)
			MenuElement.remove("place_in_incopy");

		incopyApp.placeMenu.placeItem = MenuElement.create("command", localize (incopyApp.strings4PlaceMenu[0]), "at the end of submenu/Place", "place_in_incopy", incopyApp.inCopyTargetName);
 		incopyApp.placeMenu.placeItem.onDisplay = function () {incopyApp.selectionEnabledIfIsPlaceable(this);};
 		incopyApp.placeMenu.placeItem.onSelect = function() {incopyApp.placeSelectionInInCopy(this.shiftDown);};
		
		incopyApp.placeMenuItemsInstalledInBridge = true;
		// alert("Installation of Place in InCopy menu items is done.");
	}
}

// Install menu in the bridge, but only if InDesign 20.0 is installed, and is the latest version
if (BridgeTalk.appName == incopyApp.bridgeAppName)
{
	if( incopyApp.IsAppInstalled(incopyApp.targetName, incopyApp.versionID) )
		incopyApp.installPlaceMenuItems();
}

// Install menu in the bridge, but only if InCopy 20.0 is installed and is the latest version
if (incopyApp.createInCTestMenuInBridgeApp == true)
{
	if (BridgeTalk.appName == incopyApp.bridgeAppName)
 	{
		if( incopyApp.IsAppInstalled(incopyApp.targetName, incopyApp.versionID) )
			incopyApp.installTestMenuInBridge();
 	}
}

//=====================================================================================================
// I n D e s i g n   G e n e r i c   N a m e s p a c e
//		Do this only when this version of InCopy, 20.0, is the highest installed version
//=====================================================================================================

if( incopyApp.IsAppInstalled(incopyApp.targetName, incopyApp.versionID) )
	incopy = incopyApp;
	

//alert("Loading: incopy-20.0.jsx -- completed");
